// Form Element Operations

// Function to add link item
function addLinkItem(listId) {
  const list = document.getElementById(listId);
  const item = document.createElement('div');
  item.className = 'link-item';
  item.innerHTML = `
    <div style="display:flex; margin-bottom:10px">
      <input type="text" class="link-text" placeholder="Link text" style="flex:1; margin-right:5px">
      <input type="text" class="link-url" placeholder="Link URL" style="flex:2; margin-right:5px">
      <button type="button" class="btn btn-secondary" onclick="this.parentNode.parentNode.remove(); updatePreview();">Remove</button>
    </div>
  `;
  list.appendChild(item);
  
  // Add event listeners to newly added input elements
  item.querySelectorAll('input').forEach(input => {
    input.addEventListener('input', updatePreview);
  });
  
  updatePreview(); // Update preview after adding a link
}

// Function to add content section
function addSection() {
  const container = document.getElementById('sectionsContainer');
  const sectionIndex = container.children.length + 1;
  const sectionId = 'section-' + Date.now(); // Create unique ID using timestamp
  
  const sectionDiv = document.createElement('div');
  sectionDiv.className = 'content-section';
  sectionDiv.id = sectionId;
  sectionDiv.style.marginBottom = '1.5rem';
  sectionDiv.innerHTML = `
    <div class="form-section">
      <h3>Content Block #${sectionIndex}</h3>
      <div class="form-group">
        <label>Block Title</label>
        <input type="text" class="section-title" placeholder="Enter block title">
      </div>
      <div class="form-group">
        <label>Block Content</label>
        <div class="content-editor">
          <textarea class="section-content" rows="6" placeholder="Enter block content, supports Markdown and HTML"></textarea>
          <div class="markdown-tips">
            Supports Markdown syntax and HTML:<br>
            **bold** *italic* # heading - list item [link](URL)<br>
            You can set size and alignment when inserting images
          </div>
          <div class="editor-toolbar">
            <button type="button" class="btn btn-secondary section-image-btn">Insert Image</button>
          </div>
        </div>
      </div>
      <button type="button" class="btn btn-secondary" onclick="this.parentNode.parentNode.remove(); updatePreview();">Remove Block</button>
    </div>
  `;
  container.appendChild(sectionDiv);
  
  // Add event listeners to newly added input elements
  sectionDiv.querySelectorAll('input, textarea').forEach(input => {
    input.addEventListener('input', updatePreview);
  });
  
  // Add event listener to the image button
  const imageBtn = sectionDiv.querySelector('.section-image-btn');
  imageBtn.addEventListener('click', function() {
    // Create a temporary file input element
    const fileInput = document.createElement('input');
    fileInput.type = 'file';
    fileInput.accept = 'image/*';
    fileInput.style.display = 'none';
    document.body.appendChild(fileInput);
    
    // Add change event listener
    fileInput.addEventListener('change', function() {
      // Pass the section element directly to ensure correct block operation
      handleSectionImage(this, sectionDiv);
      document.body.removeChild(this); // Remove after use
    });
    
    // Trigger the file selection dialog
    fileInput.click();
  });
  
  updatePreview(); // Update preview after adding a block
}

// Add navigation menu item
function addNavMenuItem() {
  const container = document.getElementById('navMenuList');
  const menuItemDiv = document.createElement('div');
  menuItemDiv.className = 'menu-item';
  menuItemDiv.innerHTML = `
    <div style="display:flex; margin-bottom:10px">
      <input type="text" class="menu-text" placeholder="Menu text" style="flex:1; margin-right:5px">
      <input type="text" class="menu-url" placeholder="Link URL" style="flex:2; margin-right:5px">
      <button type="button" class="btn btn-secondary" onclick="this.parentNode.parentNode.remove(); updatePreview();">Remove</button>
    </div>
  `;
  container.appendChild(menuItemDiv);
  
  // Add event listeners to newly added input elements
  menuItemDiv.querySelectorAll('input').forEach(input => {
    input.addEventListener('input', updatePreview);
  });
  
  updatePreview(); // Update preview after adding a menu item
}

// Add real-time preview functionality
const addRealtimePreview = () => {
  document.querySelectorAll('.form-input, textarea, select, #lightBg, #darkBg, #gridColumns').forEach(input => {
    input.addEventListener('input', () => {
      updatePreview();
      
      if(input.id === 'lightBg' || input.id === 'darkBg') {
        document.documentElement.style.setProperty(
          input.id === 'lightBg' ? '--light-bg-url' : '--dark-bg-url', 
          `url(${input.value})`
        );
      }
    });
  });
};

// Collect form data
function collectFormData() {
  // Collect menu items
  const menuItems = Array.from(document.querySelectorAll('.menu-item')).map(item => ({
    text: item.querySelector('.menu-text').value,
    url: item.querySelector('.menu-url').value
  }));
  // Add collection of column settings
  const gridColumns = document.getElementById('gridColumns').value;
  // Collect content blocks - ensure all content blocks are correctly selected
  const sections = Array.from(document.querySelectorAll('#sectionsContainer .content-section')).map(section => ({
    title: section.querySelector('.section-title')?.value || '',
    content: section.querySelector('.section-content')?.value || ''
  })).filter(section => section.title || section.content);

  // Collect link lists
  const topLinks = Array.from(document.querySelectorAll('#linkList1 .link-item')).map(item => ({
    text: item.querySelector('.link-text').value,
    url: item.querySelector('.link-url').value
  }));

  const bottomLinks = Array.from(document.querySelectorAll('#linkList2 .link-item')).map(item => ({
    text: item.querySelector('.link-text').value,
    url: item.querySelector('.link-url').value
  }));

  const relatedLinks = Array.from(document.querySelectorAll('#relatedLinkList .link-item')).map(item => ({
    text: item.querySelector('.link-text').value,
    url: item.querySelector('.link-url').value
  }));

  // Build configuration object
  return {
    brandName: document.getElementById('brandName').value,
    pageTitle1: document.getElementById('pageTitle1').value,
    brandSlogan: document.getElementById('brandSlogan').value,
    faviconPath: document.getElementById('faviconPath').value,
    logoPath: document.getElementById('logoPath').value,
    themeStyle: document.getElementById('themeStyle').value,
    copyrightYear: document.getElementById('copyrightYear').value,
    companyName: document.getElementById('companyName').value,
    lightBg: document.getElementById('lightBg').value,
    darkBg: document.getElementById('darkBg').value,
    menuName: document.getElementById('menuName').value,
    gridColumns: gridColumns,
    menuItems: menuItems,
    sections: sections,
    topLinks: topLinks,
    bottomLinks: bottomLinks,
    relatedLinks: relatedLinks,
    brand: {
      name: document.getElementById('brandName').value,
      slogan: document.getElementById('brandSlogan').value,
      logo: document.getElementById('logoPath').value
    },
    navigation: {
      title: document.getElementById('menuName').value,
      links: menuItems.map(item => item.text),
      socialLinks: []
    },
    formSections: [
      {
        title: "Basic Information",
        fields: ["Page Title", "Brand Name", "Theme Style"]
      }
    ],
    footer: {
      copyright: `© ${document.getElementById('copyrightYear').value} ${document.getElementById('companyName').value}`,
      links: bottomLinks.map(link => link.text)
    }
  };
}