// Original functions
function changeTheme(theme) {
    document.documentElement.setAttribute('data-theme', theme);
    localStorage.setItem('theme', theme);
}

// Handle theme switching
function applyThemeStyles() {
    const theme = document.getElementById('themeStyle').value;
    
    // Set theme
    document.documentElement.setAttribute('data-theme', theme);
    
    // Set background image URL
    const bgImg = theme === 'dark' 
        ? document.getElementById('darkBg').value || 'img/dark-bg.jpg'
        : document.getElementById('lightBg').value || 'img/light-bg.jpg';
        
    document.documentElement.style.setProperty(`--${theme}-bg-url`, `url('${bgImg}')`);
    
    // Save theme preference to localStorage
    localStorage.setItem('theme', theme);
    
    // Add transition overlay effect
    const overlay = document.createElement('div');
    overlay.style.position = 'fixed';
    overlay.style.top = '0';
    overlay.style.left = '0';
    overlay.style.width = '100%';
    overlay.style.height = '100%';
    overlay.style.backgroundColor = theme === 'dark' ? 'rgba(0,0,0,0.3)' : 'rgba(255,255,255,0.3)';
    overlay.style.zIndex = '9999';
    overlay.style.pointerEvents = 'none';
    overlay.style.transition = 'opacity 0.5s ease';
    overlay.style.opacity = '0';
    
    document.body.appendChild(overlay);
    
    setTimeout(() => {
        overlay.style.opacity = '0.5';
    }, 10);
    
    setTimeout(() => {
        overlay.style.opacity = '0';
    }, 500);
    
    setTimeout(() => {
        document.body.removeChild(overlay);
    }, 1000);
    
    // Update preview
    if (typeof updatePreview === 'function') {
        updatePreview();
    }
}

// Initialization function
document.addEventListener('DOMContentLoaded', () => {
    const savedTheme = localStorage.getItem('theme') || 'light';
    document.documentElement.setAttribute('data-theme', savedTheme);
    document.getElementById('themeStyle').value = savedTheme;
});